---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - CollapsedForms
---

# Collapsed Form (classification)

> Fails stabilization; differences dissipate or implode rather than forming persistent structure.

---

## Definition

- Closure fails at or before some $k \le n$: $⊚(R^k(∆_0))$ not satisfied
- No durable identity; interactions do not self‑reinforce

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Collapse | State loss | `Monitor`, `Alarm` |
| Dissipation | Signal decay | `Threshold`, `Fade` |
| Instability | Loop failure | `Detect`, `Break` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Collapse | Pattern loss | "Falls apart" |
| Dissipation | Fading away | "Slips away" |
| Instability | Cannot hold | "Won't stay" |

### Crosswalk (bridge)

| Technical term | Humane term | Diagnostic meaning |
|---------------|-------------|-------------------|
| State loss | Pattern loss | How form fails |
| Signal decay | Fading | How strength drops |
| Loop break | Cannot hold | How stability fails |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Damping check | Natural decay |
| Networks | Timeout detect | Connection loss |
| Cognition | Memory fade | Can't remember |
| Systems | Loop break | Falls apart |

---

## Invariants / Thresholds

Scale-dependent bounds:

### Micro Scale (ε-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| ε | |∆| < ε at interfaces | Quantum fade |
| λV | State gap failure | Level decay |

### Human Scale (ψA-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| ψA | Phase coherence loss | Pattern break |
| ∇S | Structure dissolution | Boundary fade |

### Cosmic Scale (c-bounded)

| Constant | Threshold | Test |
|----------|-----------|------|
| c | Causal disconnect | Signal loss |
| λV | Interface break | Field collapse |

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Quantum blur | Wave collapse |
| Human | λV | Gate failure | Boundary break |
| Cosmic | ψA | Phase loss | Connection fade |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Dissipation | Sub-ε signals | Too faint |
| Human | Fragmentation | Over-differentiation | Falls apart |
| Cosmic | Disconnect | Causal break | Lost contact |

---

## Diagnostic Checklist

Technical tests:
- [ ] Gate: admissible signals present (|∆| ≥ ε)?
- [ ] Capacity: within c and resource limits?
- [ ] Phase: coherence window satisfied?
- [ ] Loop: feedback chain intact?

Humane tests:
- [ ] Pattern still visible
- [ ] Feels connected
- [ ] Has living presence
- [ ] Maintains identity

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical failure metrics nor experiential dissolution alone captures its full meaning.

---

## See Also

- [[Stable Form (classification)]]
- [[Apparent Form (classification)]]
- [[Pseudo Form (classification)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented